﻿#nullable enable
namespace Hims.Api.Models.Account
{
    using Shared.Library.Enums;

    /// <summary>
    /// The kill session request.
    /// </summary>
    public class KillSessionRequest
    {
        /// <summary>
        /// Gets or sets the accountId id.
        /// </summary>
        public int AccountId { get; set; }

        /// <summary>
        /// Gets or sets the device type.
        /// </summary>
        public DeviceType? DeviceType { get; set; }

        /// <summary>
        /// Gets or sets the device id.
        /// </summary>
        public string? DeviceId { get; set; }

        /// <summary>Gets or sets the device token.</summary>
        public string? DeviceToken { get; set; }

        /// <summary>Gets or sets the is other device.</summary>
        public bool? IsOtherDevice { get; set; }
    }
}
